#pragma warning ( 3 : 4706)
/********************************* Main.cpp ***********************************\
* The main program file, contains WinMain and calls all the other functions    *
* needed to make the game run.                                                 *
\******************************************************************************/


#include <windows.h>
#include "defines.h"
#include "WinApi.h"
#include "Game.h"
#include "Init.h"
#include "Debug.h"

int WINAPI WinMain(HINSTANCE hInst, HINSTANCE hPrev, PSTR szCmd, int iCmdShow)
{
   int err;
   
   err = InitAppWindow(hInst, iCmdShow, GetCommandLine());
   if (err)
   {
      MsgBox("WinMain:InitAppWindow: Error %d", err);
      return 1;
   }
   
   err = InitGame();
   if (err)
   {
      MsgBox("WinMain:InitGame: Error %d", err);
      return 2;
   }

   err = MainGameLoop();
   if (err)
   {
      MsgBox("WinMain:MainGameLoop: Error %d", err);
      return 3;
   }

   err = DeinitGame();
   if (err)
   {
      MsgBox("WinMain:DeinitGame: Error %d", err);
      return 4;
   }

   return 0;
} /* WinMain */
